<?php
include_once("Model.inc.php");

class Workout extends Model{

    public $workoutId;
    public $userId;
    public $workoutName;
    public $notes;


    public function __construct($args = []){
        $this->workoutId = $args['workoutId'] ?? 0;
        $this->userId = $args['userId'] ?? 0;
        $this->workoutName = $args['workoutName'] ?? "";
        $this->notes = $args['notes'] ?? "";
    }

    public function isValid(){
        $valid = true;
        $this->validationErrors = [];


        if(!is_numeric($this->workoutId) || $this->workoutId <= 0){
            $valid = false;
            $this->validationErrors['workoutId'] = "workoutID is not valid";
        }

        if(!is_numeric($this->userId) || $this->userId <= 0){
            $valid = false;
            $this->validationErrors['userId'] = "userId is not valid";
        }

        if(empty($this->workoutName)){
            $valid = false;
            $this->validationErrors['workoutName'] = "Workout Name is required";
        }else if(strlen($this->workoutName) > 30){
            $valid = false;
            $this->validationErrors['workoutName'] = "Workout Name must be 30 characters or less";
        }

        if(empty($this->notes)){
            $valid = false;
            $this->validationErrors['notes'] = "Notes are required";
        }else if(strlen($this->notes) > 120){
            $valid = false;
            $this->validationErrors['notes'] = "Notes must be 120 characters or less";
        }



        return $valid;
    }
}