<?php

include_once("DataAccess.inc.php");
include_once(__DIR__ . "/../models/Exercise.inc.php");

class ExerciseDataAccess extends DataAccess{
    function __construct($link){
        parent::__construct($link);
    }

    function convertModelToRow($exercise){
        $row = [];

        $row["exercise_id"] = $exercise->exerciseId;
        $row["workout_id"] = $exercise->workoutId;
        $row["exercise_name"] = $exercise->exerciseName;
        $row["sets"] = $exercise->sets;
        $row["weight"] = $exercise->weight;
        $row["repetitions"] = $exercise->repetitions;
        $row["notes"] = $exercise->notes;

        return $row;
    }

    function convertRowToModel($row){
        $exercise = new Exercise();

        $exercise->exerciseId = $row['exercise_id'];
        $exercise->workoutId = $row['workout_id'];
        $exercise->exerciseName = $row['exercise_name'];
        $exercise->sets = $row['sets'];
        $exercise->weight = $row['weight'];
        $exercise->repetitions = $row['repetitions'];
        $exercise->notes = $row['notes'];

        return $exercise;

    }

    function getAll($args = []){
        $qStr = "SELECT
            exercise_id, 
            workout_id,
            exercise_name,
            sets,
            weight, 
            repetitions,
            notes FROM exercise";

        $result = mysqli_query($this->link, $qStr) or $this->handleError(mysqli_error($this->link));

        $allExercises = [];

        while($row = mysqli_fetch_assoc($result)){
            $allExercises[] = $this->convertRowToModel($row);
        }

        return $allExercises;
        
    }

    function getById($id){
        $qStr = "SELECT
            exercise_id, 
            workout_id,
            exercise_name,
            sets,
            weight, 
            repetitions,
            notes
            FROM exercise
            WHERE exercise_id =" . mysqli_real_escape_string($this->link, $id);

        $result = mysqli_query($this->link, $qStr) or $this->handleError(mysqli_error($this->link));

        if($result->num_rows ==1){
            $row = mysqli_fetch_assoc($result);

            $exercise = $this->convertRowToModel($row);
            return $exercise;
        }

        return false;
        
    }

    function insert($exercise){
        $row = $this->convertModelToRow($exercise);

        $qStr = "INSERT INTO exercise(
            workout_id,
            exercise_name,
            sets,
            weight, 
            repetitions,
            notes) VALUES(
                '{$row['workout_id']}',
                '{$row['exercise_name']}',
                '{$row['sets']}',
                '{$row['weight']}',
                '{$row['repetitions']}',
                '{$row['notes']}'
            )";

        $result = mysqli_query($this->link, $qStr) or $this->handleError(mysqli_error($this->link));

        if($result){
            $exercise->exerciseId = mysqli_insert_id($this->link);
            return $exercise;
        }else{
            $this->handleError("unable to insert exercise");
        }

        return false;
           
    }

    function update($exercise){
        $row = $this->convertModelToRow($exercise);

        $qStr = "UPDATE exercise SET
                workout_id = '{$row['workout_id']}',
                exercise_name = '{$row['exercise_name']}',
                sets = '{$row['sets']}',
                weight = '{$row['weight']}',
                repetitions = '{$row['repetitions']}',
                notes = '{$row['notes']}'
            WHERE exercise_id = " . $row['exercise_id'];

        $result = mysqli_query($this->link, $qStr) or $this->handleError(mysqli_error($this->link));
                
        if($result){
            return true;
        }else{
            $this->handleError("Unable to update exercise");
        }

        return false;
        
    }

    function delete($args = null){
        return null;
    }
}