<?php
include_once("Controller.inc.php");
include_once(__DIR__ . "/../models/Workout.inc.php");
include_once(__DIR__ . "/../dataaccess/WorkoutDataAccess.inc.php");

class WorkoutController extends Controller{

    function __construct($link){
        parent::__construct($link);
    }

    public function handleWorkouts(){

        $da = new WorkoutDataAccess($this->link);

        switch($_SERVER['REQUEST_METHOD']){
            case "POST":

                $data = $this->getJSONRequestBody();

                $workout = new Workout($data);

                if($workout->isValid()){
                    try{
                        $workout = $da->insert($workout);
                        $json = json_encode($workout);
                        $this->setContentType("json");
                        $this->sendStatusHeader(200);
                        echo($json);
                        die();
                    }catch(Exception $e){
                        $this->sendStatusHeader(500, $e->getMessage());
                        die();
                    }
                }else{
                    $msg = implode(',', array_values($workout->getValidationErrors()));
                    $this->sendStatusHeader(400, $msg);
                    die();
                }  

                break;
            case "GET":
                $workouts = $da->getAll();
                //print_r($workouts);die();

                // Convert the workouts to json (and set the Content-Type header)
                $json = json_encode($workouts);

                // set the headers (before echoing anything into the response body)
                $this->setContentType("json");
                $this->sendStatusHeader(200);

                // set the response body
                echo($json);
                die();

                break;
            case "OPTIONS":
                // AJAX CALLS WILL OFTEN SEND AN OPTIONS REQUEST BEFORE A PUT OR DELETE
                // TO SEE IF CERTAIN REQUEST METHODS WILL BE ALLOWED
                header("Access-Control-Allow-Methods: GET,POST");
                break;
            default:
                // set a 400 header (invalid request)
                $this->sendStatusHeader(400);
        }
    }

    public function handleSingleWorkout(){
        // We need to get the url being requested so that we can extract the workout id
        $url_path = $this->getUrlPath();
        $url_path = $this->removeLastSlash($url_path);
        //echo($url_path); die();
    
        // extract the workout id by using a regular expression
        $id = null;
        if(preg_match('/^workouts\/([0-9]*\/?)$/', $url_path, $matches)){
            $id = $matches[1];
        }
    
        $da = new WorkoutDataAccess($this->link);

        switch($_SERVER['REQUEST_METHOD']){
            case "GET":
                $workout = $da->getById($id);
                $json = json_encode($workout);
                $this->setContentType("json");
                $this->sendStatusHeader(200);
                echo($json);
                die();
                break;
            case "PUT":
                $data = $this->getJSONRequestBody();
                $workout = new Workout($data);
    
                if($workout->isValid()){
                    try{
                        if($da->update($workout)){
                            $json = json_encode($workout);
                            $this->setContentType("json");
                            $this->sendStatusHeader(200);
                            echo($json);
                        }
                    }catch(Exception $e){
                        $this->sendStatusHeader(500, $e->getMessage());
                    }
                    die();
                }else{
                    $msg = implode(',', array_values($workout->getValidationErrors()));
                    $this->sendStatusHeader(400, $msg);
                    die();
                }
                break;
            case "OPTIONS":
                // AJAX CALLS WILL OFTEN SEND AN OPTIONS REQUEST BEFORE A PUT OR DELETE
                // TO SEE IF THE PUT/DELETE WILL BE ALLOWED
                header("Access-Control-Allow-Methods: GET,PUT,DELETE");
                break;
            default:
                // set a 400 header (invalid request)
                $this->sendStatusHeader(400);
        }
        
    }

    
}             
