<?php
include_once("Controller.inc.php");
include_once(__DIR__ . "/../models/Exercise.inc.php");
include_once(__DIR__ . "/../dataaccess/ExerciseDataAccess.inc.php");

class ExerciseController extends Controller{

    function __construct($link){
        parent::__construct($link);
    }

    public function handleExercises(){

        $da = new ExerciseDataAccess($this->link);

        switch($_SERVER['REQUEST_METHOD']){
            case "POST":

                $data = $this->getJSONRequestBody();

                $exercise = new Exercise($data);

                if($exercise->isValid()){
                    try{
                        $exercise = $da->insert($exercise);
                        $json = json_encode($exercise);
                        $this->setContentType("json");
                        $this->sendStatusHeader(200);
                        echo($json);
                        die();
                    }catch(Exception $e){
                        $this->sendStatusHeader(500, $e->getMessage());
                        die();
                    }
                }else{
                    $msg = implode(',', array_values($exercise->getValidationErrors()));
                    $this->sendStatusHeader(400, $msg);
                    die();
                }

                break;
            case "GET":
                $exercises = $da->getAll();
                //print_r($exercises);die();

                // Convert the exercises to json (and set the Content-Type header)
                $json = json_encode($exercises);

                // set the headers (before echoing anything into the response body)
                $this->setContentType("json");
                $this->sendStatusHeader(200);

                // set the response body
                echo($json);
                die();

                break;
            case "OPTIONS":
                // AJAX CALLS WILL OFTEN SEND AN OPTIONS REQUEST BEFORE A PUT OR DELETE
                // TO SEE IF CERTAIN REQUEST METHODS WILL BE ALLOWED
                header("Access-Control-Allow-Methods: GET,POST");
                break;
            default:
                // set a 400 header (invalid request)
                $this->sendStatusHeader(400);
        }
    }

    public function handleSingleExercise(){
        // We need to get the url being requested so that we can extract the user id
        $url_path = $this->getUrlPath();
        $url_path = $this->removeLastSlash($url_path);
        //echo($url_path); die();
    
        // extract the user id by using a regular expression
        $id = null;
        if(preg_match('/^exercises\/([0-9]*\/?)$/', $url_path, $matches)){
            $id = $matches[1];
        }
    
        $da = new ExerciseDataAccess($this->link);

        switch($_SERVER['REQUEST_METHOD']){
            case "GET":
                $exercise = $da->getById($id);
                $json = json_encode($exercise);
                $this->setContentType("json");
                $this->sendStatusHeader(200);
                echo($json);
                die();
                break; 
            case "PUT":
                $data = $this->getJSONRequestBody();
                $exercise = new Exercise($data);

                if($exercise->isValid()){
                    try{
                        if($da->update($exercise)){
                            $json = json_encode($exercise);
                            $this->setContentType("json");
                            $this->sendStatusHeader(200);
                            echo($json);
                        }
                    }catch(Exception $e){
                        $this->sendStatusHeader(500, $e->getMessage());
                    }
                    die();
                }else{
                    $msg = implode(',', array_values($exercise->getValidationErrors()));
                    $this->sendStatusHeader(400, $msg);
                    die();
                }
                break;    
            case "OPTIONS":
                // AJAX CALLS WILL OFTEN SEND AN OPTIONS REQUEST BEFORE A PUT OR DELETE
                // TO SEE IF THE PUT/DELETE WILL BE ALLOWED
                header("Access-Control-Allow-Methods: GET,PUT,DELETE");
                break;
            default:
                // set a 400 header (invalid request)
                $this->sendStatusHeader(400);
        }
    
    }
}
